/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCadastroImobiliario;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroImobiliario;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaCadastroImobiliario")
public class CommandCarregaCadastroImobiliarioImpl
implements CommandCarregaCadastroImobiliario {
    private CadastroImobiliarioEntity cadastroImobiliario;
    private Long tipoCadastro;
    private Long cadastroGeral;
    @Resource
    private RepositoryCadastroImobiliario repositoryCadastroImobiliario;

    public CadastroImobiliarioEntity getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    public void setCadastroImobiliario(CadastroImobiliarioEntity cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public void execute() throws BaseException {
        this.cadastroImobiliario = this.repositoryCadastroImobiliario.getCadastroImobiliarioPorCodigo(this.tipoCadastro, this.cadastroGeral);
        if (this.cadastroImobiliario != null) {
            if (!EloListUtils.safeIsEmpty((List)this.cadastroImobiliario.getTestadas()).booleanValue()) {
                Hibernate.initialize((Object)this.cadastroImobiliario.getTestadas());
            }
            if (!EloListUtils.safeIsEmpty((List)this.cadastroImobiliario.getTestadasGenericas()).booleanValue()) {
                Hibernate.initialize((Object)this.cadastroImobiliario.getTestadasGenericas());
            }
            Hibernate.initialize((Object)this.cadastroImobiliario.getSegmentos());
        }
    }
}

