/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCadMobiliarioPorCpfCnpj;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaCadMobiliarioPorCpfCnpj")
public class CommandCarregaCadMobiliarioPorCpfCnpjImpl
implements CommandCarregaCadMobiliarioPorCpfCnpj {
    private String cpfCnpj;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    private CadastroMobiliarioEntity cadastroMobiliario;

    public void execute() throws BaseException {
        this.cadastroMobiliario = this.repositoryCadastroMobiliario.cadastroMobiliarioByCpfCnpj(this.cpfCnpj);
        if (this.cadastroMobiliario != null) {
            if (this.cadastroMobiliario.getMobiliarioCnaes().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioCnaes());
            }
            if (this.cadastroMobiliario.getMobiliarioCbos().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioCbos());
            }
            if (this.cadastroMobiliario.getMobiliarioContrato().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioContrato());
            }
            if (this.cadastroMobiliario.getMobiliarioSituacao().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioSituacao());
            }
            if (this.cadastroMobiliario.getContratosSociais().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getContratosSociais());
            }
            if (this.cadastroMobiliario.getMobiliarioAtividadeMeis().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioAtividadeMeis());
            }
            if (this.cadastroMobiliario.getMobiliarioServicos().size() <= 0) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioServicos());
            }
            if (this.cadastroMobiliario.getCadastroImobiliario() != null) {
                Hibernate.initialize((Object)this.cadastroMobiliario.getCadastroImobiliario());
                if (!EloListUtils.safeIsEmpty((List)this.cadastroMobiliario.getCadastroImobiliario().getTestadas()).booleanValue()) {
                    Hibernate.initialize((Object)this.cadastroMobiliario.getCadastroImobiliario().getTestadas());
                }
                if (!EloListUtils.safeIsEmpty((List)this.cadastroMobiliario.getCadastroImobiliario().getSegmentos()).booleanValue()) {
                    Hibernate.initialize((Object)this.cadastroMobiliario.getCadastroImobiliario().getSegmentos());
                }
                if (!EloListUtils.safeIsEmpty((List)this.cadastroMobiliario.getCadastroImobiliario().getTestadasGenericas()).booleanValue()) {
                    Hibernate.initialize((Object)this.cadastroMobiliario.getCadastroImobiliario().getTestadasGenericas());
                }
            }
            Hibernate.initialize((Object)this.cadastroMobiliario.getMobiliarioSituacao());
            if (this.cadastroMobiliario.getMobiliarioSituacao() != null) {
                for (MobiliarioSituacaoEntity mobiliarioSituacao : this.cadastroMobiliario.getMobiliarioSituacao()) {
                    Hibernate.initialize((Object)mobiliarioSituacao.getSituacaoMobiliario().getSituacoesMobiliarioAlvara());
                }
            }
            Hibernate.initialize((Object)this.cadastroMobiliario.getCadastroGeral().getIsencoes());
            Hibernate.initialize((Object)this.cadastroMobiliario.getCadastroGeral().getPessoa().getContatos());
        }
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }
}

