/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandBuscarDebitosEmAbertoNaSolicitacao;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DebitoParcelaEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandBuscarDebitosEmAbertoNaSolicitacao")
@Scope(value="prototype")
public class CommandBuscarDebitosEmAbertoNaSolicitacaoImpl
implements CommandBuscarDebitosEmAbertoNaSolicitacao {
    private SolicitacaoAlvaraEntity solicitacao;
    private Boolean somenteDebitosEmAberto = Boolean.TRUE;
    private List<DebitoEntity> debitosEmAberto;
    @Resource
    private RepositoryDebito repositoryDebitos;

    public void execute() throws BaseException {
        Long idSolicitacaoAlvara = this.solicitacao.getSolicitacaoAlvara();
        this.debitosEmAberto = this.somenteDebitosEmAberto != false ? this.repositoryDebitos.carregarDebitosAlvaraEmAberto(idSolicitacaoAlvara) : this.repositoryDebitos.carregarDebitosAlvara(idSolicitacaoAlvara);
        for (DebitoEntity debito : this.debitosEmAberto) {
            Hibernate.initialize((Object)debito.getParcelas());
            for (DebitoParcelaEntity parcela : debito.getParcelas()) {
                Hibernate.initialize((Object)parcela.getReceitas());
            }
        }
    }

    public void setSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setSomenteDebitosEmAberto(Boolean somenteDebitosEmAberto) {
        this.somenteDebitosEmAberto = somenteDebitosEmAberto;
    }

    public List<DebitoEntity> getDebitosEmAberto() {
        return this.debitosEmAberto;
    }
}

