/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandAberturaProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.SrvProcessoFiscalizacao;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandAberturaProcessoFiscalizacao")
@Scope(value="prototype")
public class CommandAberturaProcessoFiscalizacaoImpl
implements CommandAberturaProcessoFiscalizacao {
    private SolicitacaoAlvaraEntity solicitacao;
    private Optional<Integer> idAssunto;
    private List<ProcessoFiscalizacao> processoFiscalizacao;
    @Resource
    private SrvProcessoFiscalizacao srvProcessoFiscalizacao;

    public void execute() throws BaseException {
        try {
            this.processoFiscalizacao = this.srvProcessoFiscalizacao.abrirProcesso(this.solicitacao, this.idAssunto);
        }
        catch (URISyntaxException e) {
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void setSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public List<ProcessoFiscalizacao> getProcessoFiscalizacao() {
        return this.processoFiscalizacao;
    }

    public void setIdAssunto(Optional<Integer> idAssunto) {
        this.idAssunto = idAssunto;
    }
}

