/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento.job;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoProcessadaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoProcessamentoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.rest.service.SrvTokenAuthentication;
import br.com.elotech.portalarrecadacao.utils.CustomAppender;
import br.com.elotech.spring.SpringContext;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@DisallowConcurrentExecution
public class JobProcessaFilaRecebimentoRedeSim
extends EloLogger
implements Job {
    public static Boolean SHUTTING_DOWN = Boolean.FALSE;
    private final String CUSTOM_LOGGER_NAME = "Custom";

    private AbstractConfiguration getLoggerConfiguration() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        return (AbstractConfiguration)ctx.getConfiguration();
    }

    private CustomAppender addCustomLoggerAppender() {
        AbstractConfiguration config = this.getLoggerConfiguration();
        CustomAppender appender = new CustomAppender("Custom", Thread.currentThread().getName());
        appender.start();
        config.getLoggers().forEach((key, value) -> value.addAppender((Appender)appender, null, null));
        return appender;
    }

    private void removeCustomLoggerAppender() {
        AbstractConfiguration config = this.getLoggerConfiguration();
        config.getLoggers().forEach((key, value) -> value.removeAppender("Custom"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        FacadeFilaRecebimentoRedeSim facadeFilaRecebimentoRedeSim = (FacadeFilaRecebimentoRedeSim)SpringContext.getBean(FacadeFilaRecebimentoRedeSim.class);
        SrvTokenAuthentication srvTokenAuthentication = (SrvTokenAuthentication)SpringContext.getBean(SrvTokenAuthentication.class);
        CustomAppender appender = this.addCustomLoggerAppender();
        try {
            this.logger.info((Object)"# Iniciando processamento da fila de recebimento da RedeSim");
            List registros = facadeFilaRecebimentoRedeSim.findRegistrosParaProcessamento().stream().sorted(Comparator.comparing(registro -> registro.getTipo().getOrdem())).collect(Collectors.toList());
            this.logger.info((Object)String.format("# Itens para processar: %d", registros.size()));
            Authentication authentication = srvTokenAuthentication.getAuthenticationRedeSim();
            SecurityContextHolder.getContext().setAuthentication(authentication);
            for (FilaRecebimentoRedeSimEntity registro2 : registros) {
                if (Boolean.TRUE.equals(SHUTTING_DOWN)) {
                    break;
                }
                FilaRecebimentoProcessadaRedeSimEntity registroProcessado = null;
                try {
                    registroProcessado = facadeFilaRecebimentoRedeSim.processarRegistroFilaRecebimento(registro2);
                }
                catch (Exception ex) {
                    this.logger.error((Object)String.format("# Erro n\u00e3o esperado ao processar fila de recebimento via agendador: %s", ex.getMessage()), (Throwable)ex);
                }
                finally {
                    if (Objects.nonNull(registroProcessado) && SituacaoProcessamentoFilaRecebimentoRedeSimEnum.ERRO.equals((Object)registroProcessado.getSituacao())) {
                        registroProcessado.setObservacao(appender.getLogs());
                        facadeFilaRecebimentoRedeSim.salvarFilaRecebimentoProcessada(registroProcessado);
                    }
                    appender.clearLogs();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"# Erro ao obter os registros da fila de processamento", (Throwable)e);
        }
        finally {
            appender.stop();
            this.removeCustomLoggerAppender();
        }
    }
}

