/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento.job;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.AlvaraSincronizacaoCadastroEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.dto.webiss.RespostaSincronizacaoWebIssDTO;
import br.com.elotech.portalarrecadacao.enumerator.StatusAlvaraSincronizacaoCadastroEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.spring.SpringContext;
import java.util.Date;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobIntegracaoWebIss
extends EloLogger
implements Job {
    private static final Logger log = LoggerFactory.getLogger(JobIntegracaoWebIss.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        FacadeRedeSim facadeRedeSim = (FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class);
        try {
            List sincronizacoesRecebidas = facadeRedeSim.findAlvaraSincronizacaoCadastro(null, StatusAlvaraSincronizacaoCadastroEnum.RECEBIDO);
            List sincronizacoesErro = facadeRedeSim.findAlvaraSincronizacaoCadastro(null, StatusAlvaraSincronizacaoCadastroEnum.ERRO);
            for (AlvaraSincronizacaoCadastroEntity sincronizacao : sincronizacoesRecebidas) {
                RespostaSincronizacaoWebIssDTO statusSolicitacao = facadeRedeSim.getStatusSolicitacaoWebIss(sincronizacao.getProtocolo());
                if (!StatusAlvaraSincronizacaoCadastroEnum.SUCESSO.equals((Object)statusSolicitacao.getStatus()) && !StatusAlvaraSincronizacaoCadastroEnum.ERRO.equals((Object)statusSolicitacao.getStatus())) continue;
                sincronizacao.setStatus(statusSolicitacao.getStatus());
                sincronizacao.setMotivo(statusSolicitacao.getMotivo());
                sincronizacao.setDataHora(new Date());
                facadeRedeSim.salvarAlvaraSincronizacaoCadastro(sincronizacao);
            }
            for (AlvaraSincronizacaoCadastroEntity sincronizacao : sincronizacoesErro) {
                SolicitacaoRedeSimEntity consultaRedeSim = facadeRedeSim.getConsultaRedeSim(sincronizacao.getSolicitacaoRedeSim().getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
                facadeRedeSim.updateSolicitacaoRedeSimParaWebIss(consultaRedeSim, sincronizacao);
            }
        }
        catch (BaseException e) {
            log.error("Erro ao executar o agendador", (Throwable)e);
            throw e;
        }
    }
}

