/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento.job;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.EnquadramentoEmpresaEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoInconsistenteException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobIniciaProcessoIntegracaoRedeSim
extends EloLogger
implements Job {
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            this.atualizarSolicitacaoRedeSimAguardandoSolicitacaoDoc();
            List solicitacoesEmAnalise = this.getSolicitacaoAguardandoSolicitacaoDocumento();
            for (SolicitacaoRedeSimEntity solicitacaoRedeSim : solicitacoesEmAnalise) {
                SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa());
                this.verificarSeRealizaConsultaDeViabilidadeMei(solicitacaoRedeSim, solicitacaoRedeSimDTO);
                try {
                    SolicitacaoAlvaraEntity solicitacaoAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpjExercicioNumSolic(solicitacaoRedeSim.getSolicitacaoAlvara().getNumeroSolicitacao(), solicitacaoRedeSim.getSolicitacaoAlvara().getExercicio(), null);
                    if (this.gerouRestricaoCadastralBloqueante(solicitacaoRedeSim, solicitacaoAlvara)) {
                        return;
                    }
                    solicitacaoAlvara = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).iniciarProcessoAutomatizado(solicitacaoRedeSim);
                    this.adicionarHistoricoDeAndamentoAposGerarCadastro(solicitacaoRedeSim, solicitacaoAlvara);
                    if (!solicitacaoAlvara.isGrauRiscoBaixo() && !solicitacaoAlvara.isGrauRiscoLiberdadeEconomica() && !this.alteracaoSocioRiscoAltoRegular(solicitacaoAlvara)) continue;
                    if (solicitacaoAlvara.isSolicitacaoJuridicaNormal() && !solicitacaoAlvara.isGrauRiscoLiberdadeEconomica() && !solicitacaoAlvara.isAlteracaoRazaoOuSocioOuRazaoESocio()) {
                        ImprimirTaxasAlvara numeroCarneBloqueto = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirTaxas(solicitacaoAlvara);
                        solicitacaoRedeSim = this.recarregarSolicitacaoRedeSim(solicitacaoRedeSim);
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_ANALISE, Boolean.TRUE.booleanValue(), numeroCarneBloqueto);
                    }
                    this.gerarAlvara(solicitacaoRedeSim);
                    solicitacaoRedeSim = this.recarregarSolicitacaoRedeSim(solicitacaoRedeSim);
                    solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
                    if (solicitacaoAlvara.isGrauRiscoBaixo()) {
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO, Optional.of("Alvar\u00e1 Provis\u00f3rio"));
                        solicitacaoRedeSim.getSolicitacaoAlvara().setNumeroAlvara(solicitacaoAlvara.getNumeroAlvara());
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EMITIDO, Boolean.FALSE.booleanValue());
                        solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
                    } else if (solicitacaoAlvara.isGrauRiscoLiberdadeEconomica()) {
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA, Optional.of("Inscri\u00e7\u00e3o Municipal Gerada - Liberdade Econ\u00f4mica"));
                        solicitacaoRedeSim.getSolicitacaoAlvara().setNumeroAlvara(solicitacaoAlvara.getNumeroAlvara());
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EMITIDO, Boolean.FALSE.booleanValue());
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA, Optional.of("Inscri\u00e7\u00e3o Municipal - Liberdade Econ\u00f4mica"));
                        solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.LIBERDADE_ECONOMICA);
                    } else if (solicitacaoAlvara.isGrauRiscoAlto()) {
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ALVARA_EMITIDO, Optional.of("Alvar\u00e1 Emitido"));
                        solicitacaoRedeSim.getSolicitacaoAlvara().setNumeroAlvara(solicitacaoAlvara.getNumeroAlvara());
                        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EMITIDO, Boolean.FALSE.booleanValue());
                        solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.DEFINITIVO);
                    }
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
                }
                catch (Exception e) {
                    this.adicionarHistoricoSolicitacaoInconsistente(solicitacaoRedeSim, e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Erro na execu\u00e7\u00e3o do agendador: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void verificarSeRealizaConsultaDeViabilidadeMei(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO) throws BaseException {
        if (EnquadramentoEmpresaEnum.MEI.getCodigo().equals(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getCo_enquadramento()) && !this.possuiConsultaPreviaDeferida(solicitacaoRedeSimDTO) && !solicitacaoRedeSim.getSolicitacaoAlvara().isAlteracaoRazaoOuSocioOuRazaoESocio()) {
            this.realizarConsultaDeViabilidadeMei(solicitacaoRedeSim, solicitacaoRedeSimDTO);
        }
    }

    private void adicionarHistoricoSolicitacaoInconsistente(SolicitacaoRedeSimEntity solicitacaoRedeSim, Exception e) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.ofNullable(e.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void realizarConsultaDeViabilidadeMei(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO) throws BaseException {
        try {
            if (!solicitacaoRedeSim.getSolicitacaoAlvara().isSolicitacaoMEIPrestador() && solicitacaoRedeSim.getSolicitacaoAlvara().getCadastroImobiliario() != null) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).realizarConsultaViabilidadeMei(solicitacaoRedeSim);
            }
        }
        catch (AtividadeNaoPermitidaException anpe) {
            this.indeferirSolicitacaoEEnviarEmailAtividades(solicitacaoRedeSim, solicitacaoRedeSimDTO, anpe);
            throw anpe;
        }
        catch (CadastroImobiliarioNaoEncontradoException cinee) {
            this.adicionarHistoricoAndamentoConsultaInconsistente(solicitacaoRedeSim, cinee.getMessage());
            throw cinee;
        }
        catch (SolicitacaoInconsistenteException sie) {
            this.adicionarHistoricoAndamentoConsultaInconsistente(solicitacaoRedeSim, sie.getMessage());
            throw sie;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void gerarAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
        if (!solicitacaoAlvara.isNaturezaInicial()) {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).efetivarAlteracaoSolicitacao(solicitacaoAlvara);
        }
        solicitacaoRedeSim.setSolicitacaoAlvara(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarObsAlvaraRedeSim(solicitacaoRedeSim));
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarAlvaraRedeSim(solicitacaoAlvara);
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarObsAlvaraGerado(solicitacaoAlvara);
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).imprimirDocumentoRedeSim(solicitacaoAlvara, DocumentoTipoEnum.ALVARA_LOCALIZACAO);
    }

    private boolean alteracaoSocioRiscoAltoRegular(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return solicitacaoAlvara.isAlteracaoRazaoOuRazaoESocio() && solicitacaoAlvara.isGrauRiscoAlto() && EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getLaudos()) != false;
    }

    private boolean gerouRestricaoCadastralBloqueante(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        RestricaoAlvaraVo restricaoAlvaraVo;
        if (solicitacaoAlvara.isSolicitacaoJuridicaNormal() && !(restricaoAlvaraVo = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).verificarRestricaoCadastroAlvara(solicitacaoAlvara)).getRenderBtAvancar().booleanValue()) {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.RESTRICAO_CADASTRAL, Optional.empty());
            return true;
        }
        return false;
    }

    private void adicionarHistoricoAndamentoConsultaInconsistente(SolicitacaoRedeSimEntity solicitacaoRedeSim, String message) throws BaseException {
        this.logger.error((Object)String.format("Um erro ocorreu durante a consulta de viabilidade automatizada do protocolo: %s. Exce\u00e7\u00e3o: %s", solicitacaoRedeSim.getProtocolo(), message));
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.CONSULTA_INCONSISTENTE, Optional.of(String.format("N\u00e3o foi poss\u00edvel realizar a consulta de viabilidade: %s", message)));
    }

    private void indeferirSolicitacaoEEnviarEmailAtividades(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO, AtividadeNaoPermitidaException anpe) throws BaseException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.CONSULTA_INDEFERIDA, Optional.of(anpe.getMessage()));
        }
        catch (BaseException e) {
            this.logger.error((Object)String.format("Ocorreu um erro ao adicionar hist\u00f3rico de andamento Indeferido: %s", e.getMessage()), (Throwable)e);
        }
        try {
            EmailVo email = new EmailVo();
            email.setDestinatario(solicitacaoRedeSimDTO.getDados_solicitacao().getSolicitante().getDs_email());
            email.setAssunto(String.format("Consulta Indeferida - %s", solicitacaoRedeSim.getProtocolo()));
            email.setMensagem(EloStringUtils.replaceTemplates((String)this.getMensagemEmail(solicitacaoRedeSimDTO), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(email);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void adicionarHistoricoDeAndamentoAposGerarCadastro(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (solicitacaoAlvara.isGrauRiscoLiberdadeEconomica()) {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.CADASTRO_GERADO_LIBERDADE_ECONOMICA, Optional.of("O Cadastro foi gerado com sucesso - Liberdade Econ\u00f4mica"));
        } else if (EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getLaudos()).booleanValue()) {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.CADASTRO_ANALISE, Optional.of("O Cadastro foi atualizado para situa\u00e7\u00e3o em An\u00e1lise"));
        } else {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA, Optional.of("O Cadastro se encontra com situa\u00e7\u00e3o em An\u00e1lise, e os Laudos j\u00e1 foram Disparados para as Secretarias!"));
        }
    }

    private void atualizarSolicitacaoRedeSimAguardandoSolicitacaoDoc() throws BaseException {
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).atualizarSolicitacaoRedeSimAguardandoSolicitacaoDoc();
    }

    private List<SolicitacaoRedeSimEntity> getSolicitacaoAguardandoSolicitacaoDocumento() throws BaseException {
        ArrayList situacao = Lists.newArrayList();
        FiltroConsultaRedeSim filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        filtro.setTipo("S");
        situacao.add(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
        filtro.setSituacao((List)situacao);
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarListaConsultaRedesim(filtro);
    }

    private SolicitacaoRedeSimEntity recarregarSolicitacaoRedeSim(SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(solicitacao.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }

    private boolean possuiConsultaPreviaDeferida(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO) throws BaseException {
        SolicitacaoRedeSimEntity consultaPreviaRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaDeferidaByProtocolo(solicitacaoRedeSimDTO.getDados_solicitacao().getCo_protocolo_redesim());
        return consultaPreviaRedeSim != null;
    }

    private String getMensagemEmail(SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO) {
        StringBuilder mensagem = new StringBuilder();
        mensagem.append("<div style='font-family: Arial, times, Serif;'>");
        mensagem.append("<b>Prezado(a) Sr.(a):</b>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append(String.format("<p>A Solicita\u00e7\u00e3o de Protocolo <b>%s</b> foi Indeferida por n\u00e3o ser poss\u00edvel exercer a atividade no local informado.", solicitacaoRedeSimDTO.getDados_solicitacao().getCo_protocolo_redesim()));
        mensagem.append("</p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Atenciosamente,");
        mensagem.append("<br>");
        mensagem.append("<p><b>Alvar\u00e1 Online</b></p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<h5>Obs.: Esta \u00e9 uma mensagem autom\u00e1tica, por favor n\u00e3o responda este e-mail.</h5>");
        mensagem.append("</div>");
        return mensagem.toString();
    }
}

