/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento.job;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.facade.FacadeProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobAberturaProcessoFiscalizacao
implements Job {
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            this.abrirProcessosPendentes();
        }
        catch (BaseException e) {
            Logger.getLogger(JobAberturaProcessoFiscalizacao.class.getName()).log(Level.SEVERE, "Erro ao tentar abrir processo.", e);
        }
    }

    private void abrirProcessosPendentes() throws BaseException {
        List solicitacoes = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarSolicitacoesParaGerarProcessoFiscalizacao();
        if (EloListUtils.safeIsEmpty((List)solicitacoes).booleanValue()) {
            solicitacoes.forEach(solicitacao -> {
                try {
                    ((FacadeProcessoFiscalizacao)SpringContext.getBean(FacadeProcessoFiscalizacao.class)).abrirProcessoAutomatico(solicitacao);
                }
                catch (BaseException e) {
                    Logger.getLogger(JobAberturaProcessoFiscalizacao.class.getName()).log(Level.SEVERE, "Erro ao tentar abrir processo da solicitacao", solicitacao.getNumeroSolicitacaoExercicio());
                    Logger.getLogger(JobAberturaProcessoFiscalizacao.class.getName()).log(Level.SEVERE, "Exception", e);
                }
            });
        }
    }
}

