/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.agendamento.job.JobGeracaoAlvaraIntegracaoRedeSim;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Objects;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class AgendaProcessoGeracaoAlvaraIntegracaoRedeSim
extends EloLogger
implements ServletContextListener {
    public static Scheduler scheduler;

    protected void init() throws ObjectAlreadyExistsException {
        try {
            String habilitado = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_CADASTRO_LAUDO_VIA_INTEGRACAO_REDESIM);
            if (SimNaoEnum.getSimShortText().equalsIgnoreCase(habilitado)) {
                String tempo = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TEMPO_PROCESSO_AUTOMATICO_SOLICITACAO_REDESIM);
                this.realizarProcessoAutomatizado(tempo);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Erro ao tentar gerar o alvar\u00e1 automaticamente.", (Throwable)e);
        }
    }

    private void realizarProcessoAutomatizado(String tempo) throws SchedulerException {
        StdSchedulerFactory schedFactory = new StdSchedulerFactory();
        scheduler = schedFactory.getScheduler();
        this.logger.info((Object)"*** Criando Tarefa: JobGeracaoAlvaraIntegracaoRedeSim ***");
        JobDetail jobGeracaoAlvaraIntegracaoRedeSim = JobBuilder.newJob(JobGeracaoAlvaraIntegracaoRedeSim.class).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(Integer.parseInt(tempo)).repeatForever()).build();
        scheduler.scheduleJob(jobGeracaoAlvaraIntegracaoRedeSim, (Trigger)trigger);
        scheduler.start();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.init();
        }
        catch (Exception e) {
            this.logger.error((Object)"Erro ao inicializar o contexto.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (Objects.nonNull(scheduler)) {
                scheduler.shutdown(true);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Erro ao tentar reiniciar as tarefas.", (Throwable)e);
        }
    }
}

