/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.agendamento.job.JobProcessaFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import java.util.Objects;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@WebListener
public class AgendaProcessamentoFilaRecebimentoRedeSim
extends EloLogger
implements ServletContextListener {
    public static Scheduler scheduler;

    protected void init() throws SchedulerException, BaseException {
        String tempoSalvo = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TEMPO_PROCESSAMENTO_FILA_REDESIM);
        this.processarFila(tempoSalvo);
    }

    private void processarFila(String tempoSalvo) throws SchedulerException {
        int duracao = Integer.parseInt(tempoSalvo);
        StdSchedulerFactory schedFactory = new StdSchedulerFactory();
        scheduler = schedFactory.getScheduler();
        this.logger.info((Object)"*** Criando Tarefa: JobProcessaFilaRecebimentoRedeSim ***");
        JobDetail jobProcessamentoFilaRedeSim = JobBuilder.newJob(JobProcessaFilaRecebimentoRedeSim.class).withIdentity("ProcessamentoFilaRedeSim").build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(duracao).repeatForever()).build();
        scheduler.scheduleJob(jobProcessamentoFilaRedeSim, (Trigger)trigger);
        scheduler.start();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.init();
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Erro ao inicializar o contexto: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (Objects.nonNull(scheduler)) {
                this.logger.info((Object)"Finalizando agendador: AgendaProcessamentoFilaRecebimentoRedeSim ");
                JobProcessaFilaRecebimentoRedeSim.SHUTTING_DOWN = Boolean.TRUE;
                scheduler.shutdown(true);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Erro ao tentar finalizar o agendamento do processamento da fila de servi\u00e7os da RedeSim." + ex.getMessage()), (Throwable)ex);
        }
    }
}

