/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento;

import br.com.elotech.portalarrecadacao.agendamento.job.JobAberturaProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class AgendaAberturaProcessoFiscalizacao
implements ServletContextListener {
    public static Scheduler scheduler;

    protected void init() throws ObjectAlreadyExistsException {
        try {
            String habilitado = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_ABERTURA_PROCESSO_AUTOMATICA);
            if (SimNaoEnum.SIM.getShortText().equalsIgnoreCase(habilitado)) {
                StdSchedulerFactory schedFactory = new StdSchedulerFactory();
                scheduler = schedFactory.getScheduler();
                Logger.getLogger(AgendaAberturaProcessoFiscalizacao.class.getName()).log(Level.INFO, "*** Criando Tarefa: JobAberturaProcessoFiscalizacao ***");
                JobDetail jobAberturaProcessoFiscalizacao = JobBuilder.newJob(JobAberturaProcessoFiscalizacao.class).build();
                String hora = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HORA_EXECUCAO_PROCESSO_FISCALIZACAO_AUTOMATICO);
                SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(Integer.parseInt(hora)).repeatForever()).build();
                scheduler.scheduleJob(jobAberturaProcessoFiscalizacao, (Trigger)trigger);
                scheduler.start();
            }
        }
        catch (Exception e) {
            Logger.getLogger(AgendaAberturaProcessoFiscalizacao.class.getName()).log(Level.SEVERE, "Erro ao tentar abrir processo.", e);
        }
    }

    public void contextInitialized(ServletContextEvent ce) {
        try {
            this.init();
        }
        catch (Exception e) {
            Logger.getLogger(AgendaAberturaProcessoFiscalizacao.class.getName()).log(Level.SEVERE, "Erro ao inicializar o contexto.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        this.restart();
    }

    public void restart() {
        try {
            scheduler.shutdown(true);
        }
        catch (Exception e) {
            Logger.getLogger(AgendaAberturaProcessoFiscalizacao.class.getName()).log(Level.SEVERE, "Erro ao tentar reiniciar as tarefas.", e);
        }
    }
}

