[Setup]
PrivilegesRequired=admin
AppName="Elotech Configurador"
AppVersion=1.1.22.3
VersionInfoProductName="Elotech Configurador"
VersionInfoProductVersion=1.1.22.3
VersionInfoVersion=1.1.22.3
DefaultDirName=C:\Elotech
OutputDir=.
OutputBaseFilename=ElotechConfigurador
DisableDirPage=no
DirExistsWarning=no
Uninstallable=no

[Files]
Source: "nssm.exe"; DestDir: "{app}"
Source: "SrvComprasSocket.exe"; DestDir: "{app}\Apice"
Source: "SocketServer.exe"; DestDir: "{app}\Aise\Servidor"

[Code]
var
  ServerIPPage: TInputQueryWizardPage;

procedure InitializeWizard;
begin
  ServerIPPage := CreateInputQueryPage(wpWelcome, 'Endereo IP do Servidor', 'Digite o endereo IP do servidor que deseja conectar-se abaixo.','O endereo IPv4  composto por quatro nmeros separados por pontos. Um endereo IPv4 pode ser representado como 192.168.0.100, 10.17.19.100, 172.31.100.4');
  ServerIPPage.Add('Endereo IP:', False);
end;

procedure CurStepChanged(CurStep: TSetupStep);
var
  Drive: string;
  InstallationPath: string;
  ResultCode: Integer;
  ApcClientFile, AiseClienteFile, AiseRegServFile, BatchEloSocketFile: TStringList;
  ApcClientFilePath, SrvComprasAppPath, AiseClienteFilePath, AiseRegServFilePath, BatchEloSocketFilePath: string;
  DestDirApcClient, DestDirAise, DestDirAiseCliente, DestDirAiseServidor: string;
begin
  if CurStep = ssInstall then
  begin
    Drive := ExtractFileDrive(ExpandConstant('{app}'));
    InstallationPath := ExpandConstant('{app}');
    DestDirApcClient := ExpandConstant('{app}\Apice');
    if not DirExists(DestDirApcClient) then
      CreateDir(DestDirApcClient);

    SrvComprasAppPath := ExpandConstant('{app}\Apice\SrvComprasApp.exe');
    // Criao do arquivo ApcClient.ini
    ApcClientFilePath := ExpandConstant('{app}\Apice\ApcClient.ini');
    ApcClientFile := TStringList.Create;
    try
      ApcClientFile.Add('[Conectividade]');
      ApcClientFile.Add('Componente=socket');
      ApcClientFile.Add('[Servidores]');
      ApcClientFile.Add('Servidor01=' + ServerIPPage.Values[0]);
      ApcClientFile.Add('Caminho APICE=C:\Elotech\Apice');
      ApcClientFile.Add('Servidor02=');
      ApcClientFile.Add('Servidor03=');
      ApcClientFile.Add('Servidor04=');
      ApcClientFile.Add('Servidor05=');
      ApcClientFile.Add('[Balanceamento]');
      ApcClientFile.Add('Ativa=');
      ApcClientFile.Add('[Depurador]');
      ApcClientFile.Add('Banco de Dados=');
      ApcClientFile.Add('[Rede]');
      ApcClientFile.Add('Banda=');
      ApcClientFile.SaveToFile(ApcClientFilePath);
    finally
      ApcClientFile.Free;
    end;

    // Criao dos diretrios do Aise
    DestDirAise := ExpandConstant('{app}\Aise');
    if not DirExists(DestDirAise) then
      CreateDir(DestDirAise);

    DestDirAiseCliente := ExpandConstant('{app}\Aise\Cliente');
    if not DirExists(DestDirAiseCliente) then
      CreateDir(DestDirAiseCliente);

    DestDirAiseServidor := ExpandConstant('{app}\Aise\Servidor');
    if not DirExists(DestDirAiseServidor) then
      CreateDir(DestDirAiseServidor);

    // Criao do arquivo AISE_Cliente.ini
    AiseClienteFilePath := ExpandConstant('{app}\Aise\Cliente\AISE_Cliente.ini');
    AiseClienteFile := TStringList.Create;
    try
      AiseClienteFile.Add('[Server_05]');
      AiseClienteFile.Add('Host=' + ServerIPPage.Values[0]);
      AiseClienteFile.Add('Port=216');
      AiseClienteFile.Add('[Server_01]');
      AiseClienteFile.Add('Host=' + ServerIPPage.Values[0]);
      AiseClienteFile.Add('Port=215');
      AiseClienteFile.Add('[Server_90]');
      AiseClienteFile.Add('Host=' + ServerIPPage.Values[0]);
      AiseClienteFile.Add('Port=214');
      AiseClienteFile.Add('[Server_25]');
      AiseClienteFile.Add('Host=' + ServerIPPage.Values[0]);
      AiseClienteFile.Add('Port=213');
      AiseClienteFile.Add('[ServerApp]');
      AiseClienteFile.Add('Host=' + ServerIPPage.Values[0]);
      AiseClienteFile.Add('Port=212');
      AiseClienteFile.SaveToFile(AiseClienteFilePath);
    finally
      AiseClienteFile.Free;
    end;

    AiseRegServFilePath := ExpandConstant('{app}\Aise\Servidor\AiseRegistroServidores.cmd');
    AiseRegServFile := TStringList.Create;
    try
      AiseRegServFile.Add('@echo off');
      AiseRegServFile.Add(Drive);
      AiseRegServFile.Add('cd ' + InstallationPath);
      AiseRegServFile.Add('cd Aise');
      AiseRegServFile.Add('cd Servidor');
      AiseRegServFile.Add('forfiles /M Servidor* /C "cmd /c echo Registrando @file && @file /regserver"');
      AiseRegServFile.Add('timeout /t 2 > nul');
      AiseRegServFile.SaveToFile(AiseRegServFilePath);
    finally
      AiseRegServFile.Free;
    end;

    // Criao do arquivo InstallElotechSocket.cmd
    BatchEloSocketFilePath := ExpandConstant('{tmp}\InstallElotechSocket.cmd');
    BatchEloSocketFile := TStringList.Create;
    try
      BatchEloSocketFile.Add('@echo off');
      BatchEloSocketFile.Add('chcp 1252');
      BatchEloSocketFile.Add(Drive);
      BatchEloSocketFile.Add('cd ' + InstallationPath);
      BatchEloSocketFile.Add('setlocal enabledelayedexpansion');
      BatchEloSocketFile.Add('');
      BatchEloSocketFile.Add('set ServApiceName=EloSocket211');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe stop !ServApiceName!');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe remove !ServApiceName! confirm');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe install !ServApiceName! "' + InstallationPath + '\Apice\SrvComprasSocket.exe" "211 0"');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe set !ServApiceName! AppDirectory "' + InstallationPath + '\Apice"');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe set !ServApiceName! AppParameters "211 0"');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe set !ServApiceName! Type SERVICE_INTERACTIVE_PROCESS');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe set !ServApiceName! Start SERVICE_AUTO_START');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe set !ServApiceName! AppExit Default Exit');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe set !ServApiceName! AppPriority REALTIME_PRIORITY_CLASS');
      BatchEloSocketFile.Add(InstallationPath + '\nssm.exe start !ServApiceName!');
      BatchEloSocketFile.Add('');
      BatchEloSocketFile.Add('for /L %%i in (212,1,216) do (');
      BatchEloSocketFile.Add('  ' + 'set ServAiseName=EloSocket%%i');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe stop !ServAiseName!');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe remove !ServAiseName! confirm');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe install !ServAiseName! "' + InstallationPath + '\Aise\Servidor\SocketServer.exe" "%%i 0"');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe set !ServAiseName! AppDirectory "' + InstallationPath + '\Aise\Servidor"');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe set !ServAiseName! AppParameters "%%i 0"');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe set !ServAiseName! Type SERVICE_INTERACTIVE_PROCESS');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe set !ServAiseName! Start SERVICE_AUTO_START');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe set !ServAiseName! AppExit Default Exit');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe set !ServAiseName! AppPriority REALTIME_PRIORITY_CLASS');
      BatchEloSocketFile.Add('  ' + InstallationPath + '\nssm.exe start !ServAiseName!');
      BatchEloSocketFile.Add(')');
      BatchEloSocketFile.Add('endlocal');
      BatchEloSocketFile.SaveToFile(BatchEloSocketFilePath);
    finally
      BatchEloSocketFile.Free;
    end;

    if FileExists(SrvComprasAppPath) then begin
      Exec(ExpandConstant('{app}\Apice\SrvComprasApp.exe'), '', '', SW_HIDE, False, ResultCode);
    end;

    //Configurando o firewall
    //Exec('netsh.exe', 'advfirewall firewall add rule name="Elotech Socket 211-216" dir=in action=allow protocol=TCP localport=211-216', '', SW_HIDE, ewWaitUntilTerminated, ResultCode);
  end;
end;

[Run]
Filename: "{sys}\netsh.exe"; Parameters: "advfirewall firewall add rule name=""Elotech Socket 211-216"" dir=in action=allow protocol=TCP localport=211-216"; Flags: runhidden skipifdoesntexist; StatusMsg: "Configurando o Firewall...";
Filename: "{app}\Aise\Servidor\AiseRegistroServidores.cmd"; Parameters: ""; Flags: runhidden skipifdoesntexist; StatusMsg: "Registrando Servidores Aise...";
Filename: "{tmp}\InstallElotechSocket.cmd"; Parameters: ""; Flags: runhidden skipifdoesntexist; StatusMsg: "Configurando Elotech Borland Socket Servers...";
